package app.firezone.synk.network.API;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.AppModel;
import app.firezone.synk.network.model.BannerModel;
import app.firezone.synk.network.model.ChangePasswordRequest;
import app.firezone.synk.network.model.CheckEmailResponse;
import app.firezone.synk.network.model.CheckJoinedResponse;
import app.firezone.synk.network.model.ForgetPasswordRequest;
import app.firezone.synk.network.model.ForgetPasswordResponse;
import app.firezone.synk.network.model.GameModel;
import app.firezone.synk.network.model.JoinedMatchResponse;
import app.firezone.synk.network.model.Joined_Match_Model;
import app.firezone.synk.network.model.LoginResponse;
import app.firezone.synk.network.model.LotteryJoinedResponse;
import app.firezone.synk.network.model.LotteryModel;
import app.firezone.synk.network.model.MatchResponse;
import app.firezone.synk.network.model.MatchRulesResponse;
import app.firezone.synk.network.model.NotificationModel;
import app.firezone.synk.network.model.OtpVerifyRequest;
import app.firezone.synk.network.model.OtpVerifyResponse;
import app.firezone.synk.network.model.PaymentModel;
import app.firezone.synk.network.model.ResultResponse;
import app.firezone.synk.network.model.SliderModel;
import app.firezone.synk.network.model.TransactionModel;
import app.firezone.synk.network.model.TransactionResponse;
import app.firezone.synk.network.model.User;
import app.firezone.synk.network.model.UserResponse;
import app.firezone.synk.network.model.VideoModel;
import app.firezone.synk.network.model.Winner_Model;
import app.firezone.synk.network.model.WithdrawModel;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;


public interface MyApi {


    // Users
    @FormUrlEncoded
    @POST("users/store")
    Call<User> registerUser(
            @Field("username") String username,
            @Field("name") String name,
            @Field("email") String email,
            @Field("password") String password,
            @Field("phoneno") String phone,
            @Field("profile") String profile,
            @Field("depoBalance") long depoBalance,
            @Field("winBalance") long winBalance,
            @Field("bonusBalance") long bonusBalance,
            @Field("referred") String referred,
            @Field("joinedDate") String joinedDate,
            @Field("loginVia") String loginVia,
            @Field("status") String status,
            @Field("totalKills") long totalKills,
            @Field("matchPlayed") long matchPlayed,
            @Field("referCode") String referCode,
            @Field("totalEarning") long totalEarning
    );


    @GET("check-email")
    Call<CheckEmailResponse> checkEmailExists(@Query("email") String email);

    @GET("checkReferral")
    Call<ApiResponse> checkReferral(@Query("referCode") String referCode);

    //User Login

    @FormUrlEncoded
    @POST("users/login")
    Call<LoginResponse> loginUser(
            @Field("email") String email,
            @Field("password") String password
    );


    // User Details Fetch
    @GET("user/profile/{userId}")
    Call<ApiResponse> fetchProfileData(@Path("userId") long userId);


    @POST("users/update/{id}")
    Call<UserResponse> updateUser(
            @Path("id") long userId,
            @Body Map<String, Object> updateData
    );


    @POST("users/update/{id}")
    Call<ResponseBody> updatesUser(
            @Path("id") long userId,
            @Body Map<String, Object> updateData
    );

    @POST("users/logout")
    Call<ResponseBody> logout();


    @GET("users/order-by-earning")
    Call<List<User>> getUsersOrderedByEarning();


    //User Transaction Fetch & Add
    @GET("users/transaction/{userId}")
    Call<TransactionResponse> fetchUserTransaction(@Path("userId") long userId);

    // Forget Pass
    @POST("user/forgetpass")
    Call<ForgetPasswordResponse> forgetPassword(@Body ForgetPasswordRequest request);

    @POST("verify-otp")
    Call<OtpVerifyResponse> verifyOtp(@Body OtpVerifyRequest request);


    @POST("change-forget-password")
    Call<ApiResponse> changeForgetPassword(@Body ChangePasswordRequest request);


    @FormUrlEncoded
    @POST("changepass")
    Call<ApiResponse> changePassword(
            @Field("userId") long userId,
            @Field("currentPass") String currentPass,
            @Field("newPass") String newPass
    );



    @FormUrlEncoded
    @POST("users/transaction/store")
    Call<TransactionModel> storeUserTransaction(
            @Field("userId") String userId,
            @Field("type") String type,
            @Field("email") String email,
            @Field("amount") String amount,
            @Field("date") String date,
            @Field("time") String time,
            @Field("transactionId") String transactionId,
            @Field("method") String method,
            @Field("status") String status
    );

    //Add Admin Transaction
    @FormUrlEncoded
    @POST("/transaction/store")
    Call<TransactionModel> addTransaction(
            @Field("phoneno") String phoneno,
            @Field("type") String type,
            @Field("email") String email,
            @Field("amount") String amount,
            @Field("date") String date,
            @Field("time") String time,
            @Field("transactionId") String transactionId,
            @Field("method") String method,
            @Field("status") String status
    );


    // Payment Pages
    @GET("payment-setting")
    Call<ArrayList<PaymentModel>> fetchPaymentSetting();


    //slider
    @GET("sliders")
    Call<List<SliderModel>> fetchSlider();


    //slider 2
    @GET("banner")
    Call<List<BannerModel>> fetchBanner();


    // notification
    @GET("notification")
    Call<ArrayList<NotificationModel>> fetchNotification();

    @GET("latest-notification")
    Call<NotificationModel> fetchLatestNotification();



    // Videos
    @GET("videos")
    Call<ArrayList<VideoModel>> fetchVideos();

    //App Setting
    @GET("app-setting")
    Call<ArrayList<AppModel>> fetchAppSetting();

    //notes
    @GET("games")
    Call<ArrayList<GameModel>> fetchGameSetting();

    // lottery
    @GET("lottery")
    Call<ArrayList<LotteryModel>> fetchLottery();

    @GET("lottery/joineduser/{lotteryid}")
    Call<LotteryJoinedResponse> fetchLotteryJoined(@Path("lotteryid") long lotteryId);

    @FormUrlEncoded
    @POST("lottery/users/store")
    Call<JoinedMatchResponse> storeLotteryUser(
            @Field("lotteryid") long lotteryId,
            @Field("email") String email,
            @Field("name") String name,
            @Field("phoneno") String phoneno,
            @Field("userId") String userId,
            @Field("date") String date,
            @Field("time") String time,
            @Field("totalPay") String totalPay,
            @Field("prize") String prize,
            @Field("status") String status
    );


    @POST("lottery/joineduser/checkjoined")
    Call<CheckJoinedResponse> checkIfUserJoined(@Body HashMap<String, Object> body);

    // Match Api :-->

    @GET("match")
    Call<MatchResponse> getMatchDataById(@Query("matchid") Long matchId);

    @GET("match")
    Call<MatchResponse> getMatchDataByGameName(@Query("gamename") String gamename);


    @FormUrlEncoded
    @POST("match/users/store")
    Call<JoinedMatchResponse> storeMatchJoinedUser(
            @Field("matchid") long matchId,
            @Field("email") String email,
            @Field("username") String username,
            @Field("name") String name,
            @Field("gamename") String gamename,
            @Field("playerStatus") String playerStatus,
            @Field("kill") String kill,
            @Field("prize") String prize,
            @Field("totalPay") String totalPay,
            @Field("userId") long userId,
            @Field("joinedBy") String joinedBy,
            @Field("slot_no") int slot_no,
            @Field("position") String position
    );

    @GET("match/joineduser/{matchid}")
    Call<ArrayList<Joined_Match_Model>> fetchMatchJoinedUsers(@Path("matchid") long matchid);

    @GET("match/joinuser/checkjoined")
    Call<CheckJoinedResponse> checkIfUserJoined(
            @Query("userId") long userId,
            @Query("matchid") long matchId
    );

    //Result Match
    @GET("results")
    Call<ResultResponse> fetchResultMatchData(@Query("gamename") String gamename);



    @GET("results/joineduser/{matchid}")
    Call<ArrayList<Winner_Model>> fetchResultMatchUserData(@Path("matchid") long matchid);

    //Match Rules ->
    @GET("matchrules/{gamename}")
    Call<MatchRulesResponse> fetchMatchRules(@Path("gamename") String gamename);




    //Withdraw

    @FormUrlEncoded
    @POST("withdraw/store")
    Call<WithdrawModel> storeWithdraw(
            @Field("userId") String userId,
            @Field("amount") String amount,
            @Field("username") String username,
            @Field("emailId") String emailId,
            @Field("phoneno") String phoneno,
            @Field("date") String date,
            @Field("upiId") String upiId,
            @Field("bankname") String bankname,
            @Field("accountno") String accountno,
            @Field("ifsccode") String ifsccode,
            @Field("holdername") String holdername,
            @Field("status") String status,
            @Field("method") String method
    );





}